import * as React from 'react';
import { DataGridProcessedProps } from "../../../models/props/DataGridProps.js";
import type { GridColumnsRenderContext } from "../../../models/params/gridScrollParams.js";
import { GridStateColDef } from "../../../models/colDef/gridColDef.js";
import { GridSortColumnLookup } from "../sorting/index.js";
import { GridFilterActiveItemsLookup } from "../filter/index.js";
import { GridColumnGroupIdentifier, GridColumnIdentifier } from "../focus/index.js";
import { GridColumnMenuState } from "../columnMenu/index.js";
import { GridColumnVisibilityModel, gridColumnPositionsSelector } from "../columns/index.js";
import { GridGroupingStructure } from "../columnGrouping/gridColumnGroupsInterfaces.js";
import { PinnedColumnPosition } from "../../../internals/constants.js";
export interface UseGridColumnHeadersProps {
  visibleColumns: GridStateColDef[];
  sortColumnLookup: GridSortColumnLookup;
  filterColumnLookup: GridFilterActiveItemsLookup;
  columnHeaderTabIndexState: GridColumnIdentifier | null;
  columnGroupHeaderTabIndexState: GridColumnGroupIdentifier | null;
  columnHeaderFocus: GridColumnIdentifier | null;
  columnGroupHeaderFocus: GridColumnGroupIdentifier | null;
  headerGroupingMaxDepth: number;
  columnMenuState: GridColumnMenuState;
  columnVisibility: GridColumnVisibilityModel;
  columnGroupsHeaderStructure: GridGroupingStructure[][];
  hasOtherElementInTabSequence: boolean;
}
export interface GetHeadersParams {
  position?: PinnedColumnPosition;
  renderContext?: GridColumnsRenderContext;
  maxLastColumn?: number;
}
type OwnerState = DataGridProcessedProps;
export declare const GridColumnHeaderRow: import("@emotion/styled").StyledComponent<import("@mui/system").MUIStyledCommonProps<import("@mui/material/styles").Theme> & {
  ownerState: OwnerState;
}, Pick<React.DetailedHTMLProps<React.HTMLAttributes<HTMLDivElement>, HTMLDivElement>, keyof React.HTMLAttributes<HTMLDivElement> | keyof React.ClassAttributes<HTMLDivElement>>, {}>;
export declare const useGridColumnHeaders: (props: UseGridColumnHeadersProps) => {
  renderContext: GridColumnsRenderContext;
  leftRenderContext: {
    firstColumnIndex: number;
    lastColumnIndex: number;
  } | null;
  rightRenderContext: {
    firstColumnIndex: number;
    lastColumnIndex: number;
  } | null;
  pinnedColumns: {
    left: GridStateColDef[];
    right: GridStateColDef[];
  };
  visibleColumns: GridStateColDef[];
  columnPositions: number[];
  getFillers: (params: GetHeadersParams | undefined, children: React.ReactNode, leftOverflow: number, borderBottom?: boolean) => React.JSX.Element;
  getColumnHeadersRow: () => React.JSX.Element;
  getColumnsToRender: (params?: GetHeadersParams) => {
    renderedColumns: GridStateColDef[];
    firstColumnToRender: number;
    lastColumnToRender: number;
  };
  getColumnGroupHeadersRows: () => React.JSX.Element[] | null;
  getPinnedCellOffset: (pinnedPosition: PinnedColumnPosition | undefined, computedWidth: number, columnIndex: number, columnPositions: ReturnType<typeof gridColumnPositionsSelector>, columnsTotalWidth: number, scrollbarWidth: number) => number | undefined;
  isDragging: boolean;
  getInnerProps: () => {
    role: string;
  };
};
export {};